/*
 * Decompiled with CFR 0.152.
 */
package pakUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import kku.pak.PakEntry;
import kku.pak.PakException;
import kku.pak.PakFile;

public class UnpakMainForm
extends JFrame
implements DropTargetListener {
    private TableCellRenderer DateRenderer;
    private JMenuBar MainMenu;
    private JMenu mmFile;
    private JMenuItem miOpen;
    private JMenuItem miExit;
    private JMenu mmHelp;
    private JMenuItem miAbout;
    private JScrollPane viewPort;
    private JPopupMenu popupMenu1;
    private JMenuItem miExtract;
    private PakFile theFile;
    private List theFiles;
    private Vector heading;
    private Vector FileGridEntry;
    private JTable FLGrid;
    private String AppTitle = "Tandem Unpak GUI";

    public UnpakMainForm() {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(this.getClass().getResource("Logo.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setIconImage(bufferedImage);
        this.initComponents();
        this.InitFilelist();
    }

    private void InitFilelist() {
        this.heading = new Vector();
        this.heading.addElement("File name");
        this.heading.addElement("Code");
        this.heading.addElement("Size (bytes)");
        this.FileGridEntry = new Vector();
        this.FLGrid = new JTable(this.FileGridEntry, this.heading){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        this.FLGrid.getColumnModel().getColumn(2).setCellRenderer(defaultTableCellRenderer);
        this.FLGrid.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.FLGrid.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.FLGrid.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.FLGrid.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && UnpakMainForm.this.FLGrid.getSelectedRows().length > 0) {
                    UnpakMainForm.this.popupMenu1.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && UnpakMainForm.this.FLGrid.getSelectedRows().length > 0) {
                    UnpakMainForm.this.popupMenu1.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.viewPort.setViewportView(this.FLGrid);
    }

    private void RefreshGUI() {
        this.FileGridEntry.clear();
        for (PakEntry pakEntry : this.theFiles) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(pakEntry.filename);
            vector.addElement(pakEntry.code);
            vector.addElement(String.format("%,d", pakEntry.eof));
            this.FileGridEntry.add(vector);
        }
        this.viewPort.setViewportView(this.FLGrid);
    }

    private void OpenPakGUI(String string) throws PakException, IOException, DataFormatException {
        this.theFile = new PakFile(string);
        this.theFiles = this.theFile.getEntries();
    }

    private void miOpenActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            try {
                this.OpenPakGUI(jFileChooser.getSelectedFile().getAbsolutePath().replace("\\", "/"));
                this.setTitle(this.AppTitle + " (" + jFileChooser.getSelectedFile().getAbsolutePath() + ")");
                this.RefreshGUI();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void miExtractActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Extract to directory");
        jFileChooser.setApproveButtonText("Select");
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            int[] nArray = this.FLGrid.getSelectedRows();
            System.out.println("DoExtract " + nArray.length);
            String string = this.getTitle();
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println(this.FLGrid.getValueAt(nArray[i], 0));
                try {
                    PakEntry pakEntry = (PakEntry)this.theFiles.get(nArray[i]);
                    this.setTitle(String.format("Extracting %s", pakEntry.filename));
                    pakEntry.save(jFileChooser.getSelectedFile().getPath().replace("\\", "/") + "/" + pakEntry.filename);
                    this.setTitle(string);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void miExitActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void miAboutActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showConfirmDialog(this.getParent(), this.AppTitle + " 2.0\n" + "Copyright \u00a9 2013 Bondan Sumbodo S\n" + "sybond@gmail.com\n" + "\n" + "Developed under Unpak v1.0\n" + "Copyright \u00a9 Kari Kujansuu (kari.kujansuu@hp.com)", "About", -1);
    }

    private void initComponents() {
        this.MainMenu = new JMenuBar();
        this.mmFile = new JMenu();
        this.miOpen = new JMenuItem();
        this.miExit = new JMenuItem();
        this.mmHelp = new JMenu();
        this.miAbout = new JMenuItem();
        this.viewPort = new JScrollPane();
        this.popupMenu1 = new JPopupMenu();
        this.miExtract = new JMenuItem();
        this.setTitle(this.AppTitle);
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        ((GridBagLayout)container.getLayout()).columnWidths = new int[]{400};
        ((GridBagLayout)container.getLayout()).rowHeights = new int[]{300};
        ((GridBagLayout)container.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)container.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.mmFile.setText("File");
        this.mmFile.setMnemonic('F');
        this.miOpen.setText("Open PAK file");
        this.miOpen.setMnemonic('O');
        this.miOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnpakMainForm.this.miOpenActionPerformed(actionEvent);
            }
        });
        this.mmFile.add(this.miOpen);
        this.miExit.setText("Exit");
        this.miExit.setMnemonic('X');
        this.miExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnpakMainForm.this.miExitActionPerformed(actionEvent);
            }
        });
        this.mmFile.add(this.miExit);
        this.MainMenu.add(this.mmFile);
        this.mmHelp.setText("Help");
        this.mmHelp.setMnemonic('H');
        this.miAbout.setText("About");
        this.miAbout.setMnemonic('A');
        this.miAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnpakMainForm.this.miAboutActionPerformed(actionEvent);
            }
        });
        this.mmHelp.add(this.miAbout);
        this.MainMenu.add(this.mmHelp);
        this.setJMenuBar(this.MainMenu);
        container.add((Component)this.viewPort, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.miExtract.setText("Extract");
        this.miExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnpakMainForm.this.miExtractActionPerformed(actionEvent);
            }
        });
        this.popupMenu1.add(this.miExtract);
        DropTarget dropTarget = new DropTarget(this.viewPort, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray;
        dropTargetDropEvent.acceptDrop(1);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
            try {
                List list;
                if (!dataFlavor.isFlavorJavaFileListType() || !((list = (List)transferable.getTransferData(dataFlavor)) instanceof List)) continue;
                for (Object e : list) {
                    if (!(e instanceof File)) continue;
                    File file = (File)e;
                    String string = file.getAbsolutePath().replace("\\", "/");
                    try {
                        this.OpenPakGUI(string);
                        this.setTitle(this.AppTitle + " (" + string + ")");
                        this.RefreshGUI();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }
}

