/*
 * Decompiled with CFR 0.152.
 */
package kku.pak;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import kku.pak.PakEntry;
import kku.pak.PakException;
import kku.pak.Util;

public class PakFile {
    private List entrylist = new ArrayList();
    RandomAccessFile f;
    short version;
    short compression = 1;

    public PakFile(String string) throws PakException, IOException, DataFormatException {
        long l;
        int n = 0;
        this.f = new RandomAccessFile(string, "r");
        this.f.seek(n);
        byte[] byArray = new byte[4];
        this.f.read(byArray);
        String string2 = new String(byArray);
        if (string2.equals("PAKX")) {
            throw new PakException("Encrypted PAK archive not supported: " + string);
        }
        if (!string2.equals("PAK ")) {
            long l2 = this.f.length();
            if (l2 < 4L) {
                throw new PakException(string + " does not look like a PAK archive");
            }
            this.f.seek(l2 - 4L);
            n = this.f.readInt();
            if (n < 0 || (long)n >= l2) {
                throw new PakException(string + " does not look like a PAK archive");
            }
            this.f.seek(n);
            this.f.read(byArray);
            string2 = new String(byArray);
            if (string2.equals("PAKX")) {
                throw new PakException("Encrypted PAK archive not supported: " + string);
            }
            if (!string2.equals("PAK ")) {
                throw new PakException(string + " does not look like a PAK archive");
            }
        }
        this.version = this.f.readShort();
        System.out.println("Archive version: " + this.version);
        System.out.println("");
        int n2 = this.f.readInt();
        if (this.version > 1) {
            int n3 = this.f.readInt();
            this.compression = this.f.readShort();
            int n4 = this.f.readInt();
            l = this.f.readLong();
            if (n4 > 0) {
                throw new PakException("Multi-file PAK archive not supported: " + string);
            }
            if (l != this.f.length()) {
                System.err.println("Warning: file might be corrupted; expected EOF=" + l);
            }
        }
        this.f.seek(n + n2);
        long l3 = 0L;
        l = 0L;
        Inflater inflater = new Inflater();
        long l4 = 0L;
        while (true) {
            long l5 = this.f.getFilePointer();
            short s = this.f.readShort();
            if (s == -1) {
                ++l3;
                if (l == 0L) break;
                l = 0L;
                if (this.version != 2) continue;
                int n5 = this.f.readInt();
                l4 = l5 + 6L + (long)n5;
                continue;
            }
            byte[] byArray2 = new byte[s];
            this.f.readFully(byArray2);
            if (l == 0L) {
                int n6;
                byte[] byArray3;
                if (this.compression > 0) {
                    byArray3 = new byte[30000];
                    inflater.setInput(byArray2);
                    n6 = inflater.inflate(byArray3);
                    inflater.reset();
                } else {
                    byArray3 = byArray2;
                    n6 = byArray2.length;
                }
                if (n6 < 146) break;
                if (l3 > 1L) {
                    String string3 = new String(byArray3, 46, 24);
                    string3 = this.fnamecollapse(string3);
                    short s2 = Util.readShort(byArray3, 144);
                    int n7 = Util.readInt(byArray3, 30);
                    PakEntry pakEntry = new PakEntry(this, string3, s2, n7, l5);
                    this.entrylist.add(pakEntry);
                }
                if (this.version == 2 && l4 > 0L) {
                    this.f.seek(l4);
                    l = 1L;
                    continue;
                }
            }
            ++l;
            if (!this.odd(s)) continue;
            this.f.read();
        }
    }

    void close() throws IOException {
        this.f.close();
    }

    private boolean odd(short s) {
        return (s & 1) == 1;
    }

    private String fnamecollapse(String string) {
        String string2 = string.charAt(0) == '\\' ? "$" + string.substring(2, 8) : string.substring(0, 8);
        string2 = string2.trim();
        String string3 = string.substring(8, 16).trim();
        String string4 = string.substring(16, 24).trim();
        return string2 + "." + string3 + "." + string4;
    }

    public void dump(byte[] byArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by < 32 || by > 126) {
                if (bl) {
                    System.out.print("'");
                }
                bl = false;
                System.out.print(" " + by);
                continue;
            }
            if (!bl) {
                System.out.print("'");
            }
            bl = true;
            System.out.print((char)by);
        }
        System.out.println();
        System.out.println();
    }

    public List getEntries() {
        return this.entrylist;
    }
}

