/*
 * Decompiled with CFR 0.152.
 */
package kku.pak;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import kku.pak.PakFile;
import kku.pak.Util;

public class PakEntry {
    PakFile file;
    public String filename;
    public short code;
    private long startpos;
    public int eof = 1234;

    public PakEntry(PakFile pakFile, String string, short s, int n, long l) {
        this.file = pakFile;
        this.filename = string;
        this.code = s;
        this.eof = n;
        this.startpos = l;
    }

    public String getFileName() {
        return this.filename;
    }

    public short getCode() {
        return this.code;
    }

    public String toString() {
        return Util.pad(this.filename, 40) + Util.pad(this.code, 5) + Util.pad(this.eof, 12);
    }

    private List getEditpage(byte[] byArray) throws IOException {
        byte by;
        ArrayList<String> arrayList = new ArrayList<String>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        short s = dataInputStream.readShort();
        while (dataInputStream.available() > 0 && (by = dataInputStream.readByte()) != -1) {
            dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            int n = this.unsigned(dataInputStream.readByte());
            byte[] byArray2 = new byte[n];
            dataInputStream.read(byArray2);
            String string = this.decompressEditline(byArray2);
            arrayList.add(string);
        }
        return arrayList;
    }

    private String decompressEditline(byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(255);
        for (int i = 0; i < byArray.length; i += 1 + n) {
            int n2 = this.unsigned(byArray[i]) >> 4;
            n = byArray[i] & 0xF;
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(' ');
            }
            String string = new String(byArray, i + 1, n);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int unsigned(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    private List getEditdata(List list) throws IOException {
        ArrayList arrayList = new ArrayList();
        if (list.size() == 0) {
            return arrayList;
        }
        int n = list.size() - 1;
        byte[] byArray = (byte[])list.get(n);
        int n2 = byArray.length;
        int n3 = Util.readShort(byArray, n2 - 2);
        while (byArray.length < 2 + 6 * n3) {
            byArray = this.append((byte[])list.get(n - 1), byArray);
            --n;
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray.length - 2 - 6 * n3 + 6 * i + 4;
            short s = Util.readShort(byArray, n4);
            arrayList.addAll(this.getEditpage((byte[])list.get(s)));
        }
        return arrayList;
    }

    private byte[] append(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public List getdata() throws IOException, DataFormatException {
        RandomAccessFile randomAccessFile = this.file.f;
        randomAccessFile.seek(this.startpos);
        int n = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Inflater inflater = new Inflater();
        short s;
        while ((s = randomAccessFile.readShort()) != -1) {
            byte[] byArray = new byte[s];
            randomAccessFile.readFully(byArray);
            inflater.setInput(byArray);
            byte[] byArray2 = new byte[30000];
            int n2 = inflater.inflate(byArray2);
            inflater.reset();
            if (n > 0) {
                int n3;
                for (int i = 10; i < n2; i += n3) {
                    n3 = n2 - i;
                    if (n3 > 2048) {
                        n3 = 2048;
                    }
                    byte[] byArray3 = new byte[n3];
                    System.arraycopy(byArray2, i, byArray3, 0, n3);
                    arrayList.add(byArray3);
                }
            }
            ++n;
            if (!this.odd(s)) continue;
            randomAccessFile.read();
        }
        return this.getEditdata(arrayList);
    }

    public void save() throws IOException, DataFormatException {
        this.save(this.filename);
    }

    public void save(String string) throws IOException, DataFormatException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        RandomAccessFile randomAccessFile = this.file.f;
        randomAccessFile.seek(this.startpos);
        int n = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Inflater inflater = new Inflater();
        while (true) {
            int n2;
            Object object;
            Object object2;
            short s;
            if ((s = randomAccessFile.readShort()) == -1) {
                if (this.code == 101) {
                    object2 = this.getEditdata(arrayList);
                    object = new PrintStream(fileOutputStream);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        ((PrintStream)object).println(string2);
                    }
                    ((PrintStream)object).close();
                    return;
                }
                fileOutputStream.close();
                return;
            }
            object2 = new byte[s];
            randomAccessFile.readFully((byte[])object2);
            if (this.file.compression > 0) {
                object = new byte[30000];
                inflater.setInput((byte[])object2);
                n2 = inflater.inflate((byte[])object);
                inflater.reset();
            } else {
                object = object2;
                n2 = ((byte[])object2).length;
            }
            if (n > 0 && this.code != 101) {
                fileOutputStream.write((byte[])object, 10, n2 - 10);
            }
            if (n > 0 && this.code == 101) {
                int n3;
                for (int i = 10; i < n2; i += n3) {
                    n3 = n2 - i;
                    if (n3 > 2048) {
                        n3 = 2048;
                    }
                    byte[] byArray = new byte[n3];
                    System.arraycopy(object, i, byArray, 0, n3);
                    arrayList.add(byArray);
                }
            }
            ++n;
            if (!this.odd(s)) continue;
            randomAccessFile.read();
        }
    }

    private boolean odd(short s) {
        return (s & 1) == 1;
    }
}

